from core.hyperliquid_ws import connect_to_websocket
from bot.telegram_bot import start_bot
import asyncio
import os
import sys
import time  # Added import for time module

# Enable ANSI color support on Windows
if sys.platform == "win32":
    os.system("color")

async def main():
    # Validate initial configuration
    from lib.config_manager import ConfigManager
    config = ConfigManager()
    
    if not config.TELEGRAM_TOKEN:
        print("❌ Telegram token not configured! Please set TELEGRAM_TOKEN in .env")
        return
    
    # Create storage directory
    os.makedirs("storage", exist_ok=True)
    
    # Run main tasks
    await asyncio.gather(
        start_bot(),
        connect_to_websocket()
    )

if __name__ == "__main__":
    while True:
        try:
            asyncio.run(main())
        except KeyboardInterrupt:
            print("🛑 Bot stopped by user")
            break
        except Exception as e:
            print(f"🔥 Critical error: {str(e)}")
            print("🔄 Restarting in 10 seconds...")
            time.sleep(10)