def get_time_frame_config(time_frames):
    base_config = {
        "5m": ("5 Minutes", 300, "⚪"),
        "15m": ("15 Minutes", 900, "🔵"),
        "30m": ("30 Minutes", 1800, "🟣"),
        "1h": ("1 Hour", 3600, "🟢"),
        "4h": ("4 Hours", 14400, "🟡"),
        "12h": ("12 Hours", 43200, "🟠"),
        "1d": ("1 Day", 86400, "🔴"),
        "3d": ("3 Days", 259200, "🟤"),
        "1w": ("1 Week", 604800, "🔵")
    }
    
    config = {}
    for tf in time_frames:
        if tf in base_config:
            config[tf] = base_config[tf]
        else:
            try:
                if tf.endswith('m'):
                    minutes = int(tf[:-1])
                    seconds = minutes * 60
                    config[tf] = (f"{minutes} Minutes", seconds, "⚪")
                elif tf.endswith('h'):
                    hours = int(tf[:-1])
                    seconds = hours * 3600
                    config[tf] = (f"{hours} Hour{'s' if hours > 1 else ''}", seconds, "🟢")
                elif tf.endswith('d'):
                    days = int(tf[:-1])
                    seconds = days * 86400
                    config[tf] = (f"{days} Day{'s' if days > 1 else ''}", seconds, "🔴")
                elif tf.endswith('w'):
                    weeks = int(tf[:-1])
                    seconds = weeks * 604800
                    config[tf] = (f"{weeks} Week{'s' if weeks > 1 else ''}", seconds, "🔵")
            except ValueError:
                print(f"⚠️ Invalid time frame: {tf}")
    
    return config